/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Modifier.capability;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.common.capabilities.AirHandlerItemStack;
import me.desht.pneumaticcraft.common.core.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class PressurizableToolCap
implements ToolCapabilityProvider.IToolCapabilityProvider,
IPressurizableItem {
    public final Supplier<? extends IToolStackView> tool;
    public final LazyOptional<IPressurizableItem> capOptional;
    public final float maxPressure;
    public final LazyOptional<IAirHandlerItem> airHandlerItemLazyOptional;
    public static final ResourceLocation BASE_VOLUME_KEY = new ResourceLocation("cti", "base_volume");
    public static final ResourceLocation MAX_PRESSURE_KEY = new ResourceLocation("cti", "max_pressure");
    public static final ResourceLocation AIR_KEY = new ResourceLocation("cti", "air");
    public final AirHandlerItemStack airHandlerItemStack;

    public PressurizableToolCap(ItemStack stack, final Supplier<? extends IToolStackView> tool) {
        this.tool = tool;
        this.capOptional = LazyOptional.of(() -> this);
        this.maxPressure = tool.get().getVolatileData().getInt(MAX_PRESSURE_KEY);
        this.airHandlerItemStack = new AirHandlerItemStack(new ItemStack((ItemLike)ModItems.REINFORCED_AIR_CANISTER.get()), this.maxPressure){

            public int getAir() {
                return ((IToolStackView)tool.get()).getPersistentData().getInt(AIR_KEY);
            }

            public void addAir(int amount) {
                if (((IToolStackView)tool.get()).getPersistentData().contains(AIR_KEY, 3)) {
                    ((IToolStackView)tool.get()).getPersistentData().putInt(AIR_KEY, ((IToolStackView)tool.get()).getPersistentData().getInt(AIR_KEY) + amount);
                } else {
                    ((IToolStackView)tool.get()).getPersistentData().putInt(AIR_KEY, amount);
                }
            }

            public int getBaseVolume() {
                return ((IToolStackView)tool.get()).getVolatileData().getInt(BASE_VOLUME_KEY);
            }

            public float getPressure() {
                return (float)this.getAir() / (float)this.getBaseVolume();
            }

            public void setBaseVolume(int newBaseVolume) {
            }

            public int getVolume() {
                return this.getBaseVolume();
            }

            public float maxPressure() {
                return ((IToolStackView)tool.get()).getVolatileData().getFloat(MAX_PRESSURE_KEY);
            }
        };
        this.airHandlerItemLazyOptional = LazyOptional.of(() -> this.airHandlerItemStack);
    }

    public <T> LazyOptional<T> getCapability(IToolStackView iToolStackView, Capability<T> capability) {
        if (this.tool.get().getVolatileData().getInt(BASE_VOLUME_KEY) > 0) {
            return PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY.orEmpty(capability, this.airHandlerItemLazyOptional);
        }
        return LazyOptional.empty();
    }

    public int getBaseVolume() {
        return this.tool.get().getVolatileData().getInt(BASE_VOLUME_KEY);
    }

    public int getVolumeUpgrades(ItemStack itemStack) {
        return 0;
    }

    public int getAir(ItemStack itemStack) {
        return this.tool.get().getPersistentData().getInt(AIR_KEY);
    }

    public int getEffectiveVolume(ItemStack stack) {
        return this.getBaseVolume();
    }

    public static float getPressure(IToolStackView tool) {
        return (float)tool.getPersistentData().getInt(AIR_KEY) / (float)tool.getVolatileData().getInt(BASE_VOLUME_KEY);
    }

    public static int getAir(IToolStackView tool) {
        return tool.getPersistentData().getInt(AIR_KEY);
    }

    public static void addAir(IToolStackView tool, int amount) {
        if (tool.getPersistentData().contains(AIR_KEY, 3)) {
            tool.getPersistentData().putInt(AIR_KEY, tool.getPersistentData().getInt(AIR_KEY) + amount);
            if (tool.getPersistentData().getInt(AIR_KEY) < 0) {
                tool.getPersistentData().putInt(AIR_KEY, 0);
            }
        } else {
            tool.getPersistentData().putInt(AIR_KEY, amount);
        }
    }

    public static int getBaseVolume(IToolStackView tool) {
        return tool.getVolatileData().getInt(BASE_VOLUME_KEY);
    }

    public static float getMaxPressure(IToolStackView tool) {
        return tool.getVolatileData().getInt(MAX_PRESSURE_KEY);
    }
}

